# lab2_ROC_Graphs.R
#
# R script file for making ROC Graphs from
# the *_grf file produced by RscorePlus.
# Two plots are produced in a single graphics
# window from the data in the *_grf file:
#	probability ROC
#	z-score probability ROC
# 13 September 2010

# read the RscorePlus graphic file (*_grf) into a data frame
fn <- file.choose()					# choose a file name
df <- read.delim(fn, header=TRUE)	# read data from file

# Edit below to put in your own name
mn = "Your Name"
md = paste(df$Model[1], "Model")	# name of model

# plot ROC curve for without eyes in red and with eyes in blue
par(mfrow = c(1,2))	# two graphs per figure
par(pty = "s")		# make plots square

# probability plot
plot(Obs_pYs1 ~ Obs_pYs0,
	data = df,
	pch = 21, col = "red",
	xlim = c(0, 1),
	ylim = c(0, 1),
	xlab = "False Alarm Rate",
	ylab = "Hit Rate",
	main = paste(mn, md, "Probability ROC", sep="\n"))
points(Obs_pYs2 ~ Obs_pYs0, data=df, pch=19, col="blue")
lines(Pred_pYs1 ~ Pred_pYs0, data=df, col="red", lwd = 2)
lines(Pred_pYs2 ~ Pred_pYs0, data=df, col="blue", lwd = 2)
text(.4, .60, "Without\nEyes", col="red", cex=0.75)
text(.2, .90, "With\nEyes", col="blue", cex=0.75)
abline(0,1)

# z-score plot
plot(Obs_zYs1 ~ Obs_zYs0, data=df, pch=21, col="red",
	xlim=c(-2.5, 2.5),
	ylim=c(-2.5, 2.5),
	xlab="z-score of False Alarm Rate",
	ylab="z-score of Hit Rate",
	main = paste(mn, md, "Z-Score ROC", sep="\n"))
points(Obs_zYs2 ~ Obs_zYs0, data=df, pch=19, col="blue")
lines(Pred_zYs1 ~ Pred_zYs0, data=df, col="red", lwd=2)
lines(Pred_zYs2 ~ Pred_zYs0, data=df, col="blue", lwd=2)
text(1.4, .6, "Without\nEyes", col="red", cex=0.75)
text(-1.7, 1, "With\nEyes", col="blue", cex=0.75)
abline(0,1)

par(pty = "m")		# restore the normal size of plots
par(mfrow = c(1,1))	# restore the single plot per window mode

